/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.ventas;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidableAnotado;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Establecimiento
extends ObjetoModeloSucesorValidableAnotado<Iva>
implements InformacionEditable<Establecimiento>,
Exportable,
Importable {
    private static final long serialVersionUID = -636938666636425016L;
    public static final String C_ESTABLECIMIENTO = "establecimiento";
    public static final String C_TOTAL_VENTAS = "totalVentas";
    private static final String TOTAL_COMPENSADO = "totalCompensado";
    private static final String MSG_REG_ESTBLM = "El valor Establecimiento debe ser solo n\u00fameros. 3 d\u00edgitos. ";
    private static final String MSG_TOTAL_VENTAS = "El valor Total Ventas debe ser 12 enteros y 2 decimales. ";
    private static final String MSG_ESTABLECIMIENTO = "Debe ingresar el valor de Establecimiento";
    private static final String MSG_TOTAL_COMPENSACION = "El valor de Total de IVA Compensado en el establecimiento por ventas  debe ser 12 enteros y 2 decimales. ";
    @NotNull(message="Debe ingresar el valor de Establecimiento")
    @Pattern(regexp="\\d{3}(?<!000)", message="El valor Establecimiento debe ser solo n\u00fameros. 3 d\u00edgitos. ")
    private String establecimiento = "000";
    @NotNull(message="Debe ingresar el valor de Total Ventas")
    @Pattern(regexp="[0-9]{1,12}\\.[0-9]{2}|[0-9]{1,12}|[\\-][0-9]{1,12}\\.[0-9]{2}|[\\-][0-9]{1,12}", message="El valor Total Ventas debe ser 12 enteros y 2 decimales. ")
    private String totalVentas = "0.00";
    @NotNull(message="Debe ingresar el valor de Total Compensado")
    @Pattern(regexp="[0-9]{1,12}\\.[0-9]{2}|[0-9]{1,12}|[\\-][0-9]{1,12}\\.[0-9]{2}|[\\-][0-9]{1,12}", message="El valor de Total de IVA Compensado en el establecimiento por ventas  debe ser 12 enteros y 2 decimales. ")
    private String totalCompensado = "0.00";

    protected ResultadoValidacion validarObjeto() {
        return new ResultadoValidacion().pasarValidacion();
    }

    public Establecimiento crearCopiaEdicion() {
        Establecimiento copia = new Establecimiento();
        copia.setEstablecimiento(this.establecimiento);
        copia.setTotalVentas(this.totalVentas);
        copia.setTotalCompensado(this.totalCompensado);
        copia.setPropietario((Iva)this.propietario);
        return copia;
    }

    public void actualizarInformacion(Establecimiento copiaEdicion) {
        this.setEstablecimiento(copiaEdicion.getEstablecimiento());
        this.setTotalVentas(copiaEdicion.getTotalVentas());
        this.setTotalCompensado(copiaEdicion.getTotalCompensado());
    }

    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName("codEstab");
        Element eValor = (Element)valorList.item(0);
        this.establecimiento = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("ventasEstab");
        eValor = (Element)valorList.item(0);
        this.totalVentas = eValor.getTextContent().trim();
        if (Util.existeElementoImportar(elemento, "ivaComp")) {
            valorList = elemento.getElementsByTagName("ivaComp");
            eValor = (Element)valorList.item(0);
            this.totalCompensado = eValor.getTextContent().trim();
        }
        return this;
    }

    public Element exportar(Document documento, Element elemento) {
        Element ventaEst = documento.createElement("ventaEst");
        Element em = documento.createElement("codEstab");
        em.setTextContent(this.getEstablecimiento());
        ventaEst.appendChild(em);
        em = documento.createElement("ventasEstab");
        em.setTextContent(this.getTotalVentas());
        ventaEst.appendChild(em);
        this.exportarMontoCompensadoDesdeMayo2016(documento, ventaEst);
        return ventaEst;
    }

    private void exportarMontoCompensadoDesdeMayo2016(Document documento, Element ventaEst) {
        if (((Iva)this.getPropietario()).periodo.isAnexoEnPeriodoDesdeMayo2016()) {
            Element em = documento.createElement("ivaComp");
            em.setTextContent(this.getTotalCompensado());
            ventaEst.appendChild(em);
        }
    }

    public String getEstablecimiento() {
        return this.establecimiento;
    }

    public String getTotalVentas() {
        return this.totalVentas;
    }

    public String getTotalCompensado() {
        return this.totalCompensado;
    }

    public void setEstablecimiento(String establecimiento) {
        String oldValue = this.establecimiento;
        this.establecimiento = StringUtil.isNullOrEmpty((String)establecimiento) ? null : establecimiento.toUpperCase();
        this.firePropertyChange(C_ESTABLECIMIENTO, oldValue, this.establecimiento);
    }

    public void setTotalVentas(String totalVentas) {
        String oldValue = this.totalVentas;
        this.totalVentas = totalVentas;
        this.firePropertyChange(C_TOTAL_VENTAS, oldValue, this.totalVentas);
    }

    public void setTotalCompensado(String totalCompensado) {
        String oldValue = this.totalCompensado;
        this.totalCompensado = totalCompensado;
        this.firePropertyChange(TOTAL_COMPENSADO, oldValue, this.totalCompensado);
    }
}

